/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.configuration.search.LuceneConfiguration;
import de.qfm.erp.service.configuration.search.SearchConfiguration;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EEntityIndexField;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.EUserIndexField;
import de.qfm.erp.service.model.search.IndexField;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.UpperCaseFilterFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class LuceneConfiguration
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(LuceneConfiguration.class);
    private final SearchConfiguration searchConfiguration;

    public void afterPropertiesSet() {
        log.info("Using Stemming: {}", (Object)this.searchConfiguration.isEnabledStem());
        log.info("Using Lucene Path: {} with ReCreate: {}", (Object)this.searchConfiguration.getLocalFileStorageFolder(), (Object)this.searchConfiguration.isLuceneIndexRecreate());
    }

    @Bean(value={"indexDirectory"})
    public Directory directory() throws IOException {
        File localDirectory = new File(this.searchConfiguration.getLocalFileStorageFolder());
        File localIndexDirectory = new File(localDirectory, "index");
        Path path = this.validateAndCreatePath(localIndexDirectory);
        log.info("Index Directory: {}", (Object)path.toAbsolutePath());
        return FSDirectory.open((Path)path);
    }

    @Bean(value={"spellcheckDirectory"})
    public Directory spellcheckDirectory() throws IOException {
        File localDirectory = new File(this.searchConfiguration.getLocalFileStorageFolder());
        File localIndexDirectory = new File(localDirectory, "spellcheck");
        Path path = this.validateAndCreatePath(localIndexDirectory);
        log.info("Spellcheck Directory: {}", (Object)path.toAbsolutePath());
        return FSDirectory.open((Path)path);
    }

    @Bean
    public IndexWriterConfig.OpenMode openMode() {
        IndexWriterConfig.OpenMode openMode = this.searchConfiguration.isLuceneIndexRecreate() ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
        log.info("Opening Index in: {}", (Object)openMode);
        return openMode;
    }

    @Bean(value={"indexAnalyzer"})
    public Analyzer indexAnalyzer() throws IOException {
        ImmutableMap.Builder analyzerBuilder = ImmutableMap.builder();
        ImmutableSet allNumericFields = ImmutableSet.builder().addAll(ECustomerIndexField.NUMERIC_FIELDS).addAll(EInvoiceIndexField.NUMERIC_FIELDS).addAll(EMeasurementIndexField.NUMERIC_FIELDS).addAll(EStageIndexField.NUMERIC_FIELDS).addAll(EUserIndexField.NUMERIC_FIELDS).build();
        allNumericFields.forEach(item -> analyzerBuilder.put((Object)item.fieldName(), (Object)new EdgeNgramAnalyzer()));
        ImmutableSet allNoAnalyzer = ImmutableSet.builder().addAll(EMeasurementIndexField.ALL_NO_ANALYZER_FIELDS).addAll(EInvoiceIndexField.ALL_NO_ANALYZER_FIELDS).addAll(EStageIndexField.ALL_NO_ANALYZER_FIELDS).addAll(EEntityIndexField.ALL_NO_ANALYZER_FIELDS).build();
        CustomAnalyzer keyUCaseAnalyzer = CustomAnalyzer.builder().withTokenizer(KeywordTokenizerFactory.class, new String[0]).addTokenFilter(UpperCaseFilterFactory.class, new String[0]).build();
        allNoAnalyzer.forEach(arg_0 -> LuceneConfiguration.lambda$indexAnalyzer$1(analyzerBuilder, (Analyzer)keyUCaseAnalyzer, arg_0));
        analyzerBuilder.put((Object)EMeasurementIndexField.ENTRY_TYPE.fieldName(), (Object)new KeyAnalyzer());
        ImmutableMap perFieldAnalyzer = analyzerBuilder.build();
        return new PerFieldAnalyzerWrapper((Analyzer)new TextAnalyzer(), (Map)perFieldAnalyzer);
    }

    @Bean(value={"indexWriter"})
    public IndexWriter indexWriter() throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(this.indexAnalyzer());
        config.setOpenMode(this.openMode());
        return new IndexWriter(this.directory(), config);
    }

    @Bean(name={"spellcheckAnalyzer"})
    public Analyzer spellcheckAnalyzer() {
        ImmutableMap.Builder analyzerBuilder = ImmutableMap.builder();
        analyzerBuilder.put((Object)EMeasurementIndexField.SPELLCHECK__CLAZZ.fieldName(), (Object)new StandardAnalyzer());
        analyzerBuilder.put((Object)EMeasurementIndexField.SPELLCHECK__FIELD.fieldName(), (Object)new StandardAnalyzer());
        analyzerBuilder.put((Object)EMeasurementIndexField.SPELLCHECK__VALUE.fieldName(), (Object)new StandardAnalyzer());
        analyzerBuilder.put((Object)EMeasurementIndexField.SPELLCHECK__PHONETIC.fieldName(), (Object)new PhoneticAnalyzer());
        ImmutableMap perFieldAnalyzer = analyzerBuilder.build();
        return new PerFieldAnalyzerWrapper((Analyzer)new TextAnalyzer(), (Map)perFieldAnalyzer);
    }

    @Bean(value={"spellcheckWriter"})
    public IndexWriter spellcheckWriter() throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(this.spellcheckAnalyzer());
        config.setOpenMode(this.openMode());
        return new IndexWriter(this.spellcheckDirectory(), config);
    }

    @Bean(value={"searcherManager"})
    public SearcherManager searcherManager() throws IOException {
        SearcherManager searcherManager = new SearcherManager(this.indexWriter(), new SearcherFactory());
        searcherManager.addListener(LuceneConfiguration.refreshListener((String)"Index Add"));
        searcherManager.removeListener(LuceneConfiguration.refreshListener((String)"Index Remove"));
        return searcherManager;
    }

    @Bean(value={"searcherSpellcheckManager"})
    public SearcherManager searcherSpellcheckManager() throws IOException {
        SearcherManager searcherManager = new SearcherManager(this.spellcheckWriter(), new SearcherFactory());
        searcherManager.addListener(LuceneConfiguration.refreshListener((String)"Spellcheck Add"));
        searcherManager.removeListener(LuceneConfiguration.refreshListener((String)"Spellcheck Remove"));
        return searcherManager;
    }

    @Nonnull
    private static ReferenceManager.RefreshListener refreshListener(@NonNull String source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private Path validateAndCreatePath(@NonNull File localAutoCompleteDirectory) {
        if (localAutoCompleteDirectory == null) {
            throw new NullPointerException("localAutoCompleteDirectory is marked non-null but is null");
        }
        if (!localAutoCompleteDirectory.exists()) {
            boolean directoryCreated = localAutoCompleteDirectory.mkdirs();
            if (!directoryCreated) {
                throw new IllegalStateException(String.format("Supposed Path: %s could not be created, check permissions", this.searchConfiguration.getLocalFileStorageFolder()));
            }
        } else if (localAutoCompleteDirectory.isFile()) {
            throw new IllegalArgumentException(String.format("Supposed Path: %s is a File instead of a directory", this.searchConfiguration.getLocalFileStorageFolder()));
        }
        return localAutoCompleteDirectory.toPath();
    }

    public LuceneConfiguration(SearchConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
    }

    private static /* synthetic */ void lambda$indexAnalyzer$1(ImmutableMap.Builder analyzerBuilder, Analyzer keyUCaseAnalyzer, IndexField item) {
        analyzerBuilder.put((Object)item.fieldName(), (Object)keyUCaseAnalyzer);
    }
}

