/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.google.common.base.Splitter;
import jakarta.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:/config/psx-config.properties"}, ignoreResourceNotFound=true)})
public class PsxConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(PsxConfig.class);
    @Value(value="${psx.protocol:https}")
    private String protocol;
    @Value(value="${psx.host:psx-api.staging.leancoders.de}")
    private String host;
    @Value(value="${psx.port:443}")
    private int port;
    @Value(value="${psx.apiPath:}")
    private String apiPath;
    @Value(value="${psx.username:admin}")
    private String username;
    @Value(value="${psx.password:admin}")
    private String password;
    @Value(value="${psx.measurement.construction_site_states:PLANNED,NEW,IN_PROGRESS,OUTAGE,SENT}")
    private String measurementConstructionSiteStatesString;
    @Value(value="${psx.measurement.release_order_states:PLANNED,NEW,IN_PROGRESS}")
    private String measurementReleaseOrderStatesString;
    private String baseUri;
    private Iterable<String> measurementConstructionSiteStates;
    private Iterable<String> measurementReleaseOrderStates;

    public void afterPropertiesSet() {
        this.baseUri = String.format("%s://%s%s", this.protocol, this.host, this.apiPath);
        this.measurementConstructionSiteStates = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)this.measurementConstructionSiteStatesString);
        this.measurementReleaseOrderStates = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)this.measurementReleaseOrderStatesString);
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded PsxConfig: {}", (Object)this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMeasurementConstructionSiteStatesString() {
        return this.measurementConstructionSiteStatesString;
    }

    public String getMeasurementReleaseOrderStatesString() {
        return this.measurementReleaseOrderStatesString;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public Iterable<String> getMeasurementConstructionSiteStates() {
        return this.measurementConstructionSiteStates;
    }

    public Iterable<String> getMeasurementReleaseOrderStates() {
        return this.measurementReleaseOrderStates;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMeasurementConstructionSiteStatesString(String measurementConstructionSiteStatesString) {
        this.measurementConstructionSiteStatesString = measurementConstructionSiteStatesString;
    }

    public void setMeasurementReleaseOrderStatesString(String measurementReleaseOrderStatesString) {
        this.measurementReleaseOrderStatesString = measurementReleaseOrderStatesString;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setMeasurementConstructionSiteStates(Iterable<String> measurementConstructionSiteStates) {
        this.measurementConstructionSiteStates = measurementConstructionSiteStates;
    }

    public void setMeasurementReleaseOrderStates(Iterable<String> measurementReleaseOrderStates) {
        this.measurementReleaseOrderStates = measurementReleaseOrderStates;
    }

    public String toString() {
        return "PsxConfig(protocol=" + this.getProtocol() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", apiPath=" + this.getApiPath() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", measurementConstructionSiteStatesString=" + this.getMeasurementConstructionSiteStatesString() + ", measurementReleaseOrderStatesString=" + this.getMeasurementReleaseOrderStatesString() + ", baseUri=" + this.getBaseUri() + ", measurementConstructionSiteStates=" + String.valueOf(this.getMeasurementConstructionSiteStates()) + ", measurementReleaseOrderStates=" + String.valueOf(this.getMeasurementReleaseOrderStates()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsxConfig)) {
            return false;
        }
        PsxConfig other = (PsxConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$apiPath = this.getApiPath();
        String other$apiPath = other.getApiPath();
        if (this$apiPath == null ? other$apiPath != null : !this$apiPath.equals(other$apiPath)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$measurementConstructionSiteStatesString = this.getMeasurementConstructionSiteStatesString();
        String other$measurementConstructionSiteStatesString = other.getMeasurementConstructionSiteStatesString();
        if (this$measurementConstructionSiteStatesString == null ? other$measurementConstructionSiteStatesString != null : !this$measurementConstructionSiteStatesString.equals(other$measurementConstructionSiteStatesString)) {
            return false;
        }
        String this$measurementReleaseOrderStatesString = this.getMeasurementReleaseOrderStatesString();
        String other$measurementReleaseOrderStatesString = other.getMeasurementReleaseOrderStatesString();
        if (this$measurementReleaseOrderStatesString == null ? other$measurementReleaseOrderStatesString != null : !this$measurementReleaseOrderStatesString.equals(other$measurementReleaseOrderStatesString)) {
            return false;
        }
        String this$baseUri = this.getBaseUri();
        String other$baseUri = other.getBaseUri();
        if (this$baseUri == null ? other$baseUri != null : !this$baseUri.equals(other$baseUri)) {
            return false;
        }
        Iterable this$measurementConstructionSiteStates = this.getMeasurementConstructionSiteStates();
        Iterable other$measurementConstructionSiteStates = other.getMeasurementConstructionSiteStates();
        if (this$measurementConstructionSiteStates == null ? other$measurementConstructionSiteStates != null : !this$measurementConstructionSiteStates.equals(other$measurementConstructionSiteStates)) {
            return false;
        }
        Iterable this$measurementReleaseOrderStates = this.getMeasurementReleaseOrderStates();
        Iterable other$measurementReleaseOrderStates = other.getMeasurementReleaseOrderStates();
        return !(this$measurementReleaseOrderStates == null ? other$measurementReleaseOrderStates != null : !this$measurementReleaseOrderStates.equals(other$measurementReleaseOrderStates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PsxConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $apiPath = this.getApiPath();
        result = result * 59 + ($apiPath == null ? 43 : $apiPath.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $measurementConstructionSiteStatesString = this.getMeasurementConstructionSiteStatesString();
        result = result * 59 + ($measurementConstructionSiteStatesString == null ? 43 : $measurementConstructionSiteStatesString.hashCode());
        String $measurementReleaseOrderStatesString = this.getMeasurementReleaseOrderStatesString();
        result = result * 59 + ($measurementReleaseOrderStatesString == null ? 43 : $measurementReleaseOrderStatesString.hashCode());
        String $baseUri = this.getBaseUri();
        result = result * 59 + ($baseUri == null ? 43 : $baseUri.hashCode());
        Iterable $measurementConstructionSiteStates = this.getMeasurementConstructionSiteStates();
        result = result * 59 + ($measurementConstructionSiteStates == null ? 43 : $measurementConstructionSiteStates.hashCode());
        Iterable $measurementReleaseOrderStates = this.getMeasurementReleaseOrderStates();
        result = result * 59 + ($measurementReleaseOrderStates == null ? 43 : $measurementReleaseOrderStates.hashCode());
        return result;
    }
}

