/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:/config/print-layout-config.properties"}, ignoreResourceNotFound=true)})
public class PrintLayoutConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(PrintLayoutConfig.class);
    @Value(value="${font.regular.path:}")
    private String fontRegularPath;
    @Value(value="${font.bold.path:}")
    private String fontBoldPath;
    @Value(value="${font.italic.path:}")
    private String fontItalicPath;
    private File fontRegular;
    private byte[] fontRegularBuffer;
    private File fontBold;
    private byte[] fontBoldBuffer;
    private File fontItalic;
    private byte[] fontItalicBuffer;
    @Value(value="${aggregation.font.size.default:7}")
    private Integer aggregationFontSize;
    @Value(value="${details.font.size.default:7}")
    private Integer detailsFontSize;
    @Value(value="${title.font.size.default:7}")
    private Integer titleFontSize;
    @Value(value="${header.font.size.default:7}")
    private Integer headerFontSize;
    @Value(value="${footer.font.size.default:7}")
    private Integer footerFontSize;
    @Value(value="${meta.font.size.default:7}")
    private Integer metaFontSize;
    @Value(value="${aggregation.font.size.smaller:7}")
    private Integer aggregationFontSizeSmaller;
    @Value(value="${details.font.size.smaller:7}")
    private Integer detailsFontSizeSmaller;
    @Value(value="${title.font.size.smaller:7}")
    private Integer titleFontSizeSmaller;
    @Value(value="${header.font.size.smaller:7}")
    private Integer headerFontSizeSmaller;
    @Value(value="${footer.font.size.smaller:7}")
    private Integer footerFontSizeSmaller;
    @Value(value="${meta.font.size.smaller:7}")
    private Integer metaFontSizeSmaller;
    @Value(value="${aggregation.font.size.smallest:7}")
    private Integer aggregationFontSizeSmallest;
    @Value(value="${details.font.size.smallest:7}")
    private Integer detailsFontSizeSmallest;
    @Value(value="${title.font.size.smallest:7}")
    private Integer titleFontSizeSmallest;
    @Value(value="${header.font.size.smallest:7}")
    private Integer headerFontSizeSmallest;
    @Value(value="${footer.font.size.smallest:7}")
    private Integer footerFontSizeSmallest;
    @Value(value="${meta.font.size.smallest:7}")
    private Integer metaFontSizeSmallest;
    @Value(value="${footer.1.width:0}")
    private Float footer1Width;
    @Value(value="${footer.2.width:0}")
    private Float footer2Width;
    @Value(value="${footer.3.width:0}")
    private Float footer3Width;
    @Value(value="${footer.4.width:0}")
    private Float footer4Width;
    @Value(value="${footer.5.width:0}")
    private Float footer5Width;
    @Value(value="${header.1.width:0}")
    private Float header1Width;
    @Value(value="${header.2.width:0}")
    private Float header2Width;
    @Value(value="${header.3.width:0}")
    private Float header3Width;
    @Value(value="${header.4.width:0}")
    private Float header4Width;
    @Value(value="${invoice.logo.height:100}")
    private Integer invoiceLogoHeight;
    @Value(value="${invoice.logo.paddding:0}")
    private Float invoiceLogoPadding;
    @Value(value="${invoice.logo.path:}")
    private String invoiceLogoPath;
    private File invoiceLogoFile;
    private byte[] invoiceLogoBuffer;
    @Value(value="${measurement.logo.height:100}")
    private Integer measurementLogoHeight;
    @Value(value="${measurement.logo.padding:0}")
    private Float measurementLogoPadding;
    @Value(value="${measurement.logo.path:}")
    private String measurementLogoPath;
    private File measurementLogoFile;
    private byte[] measurementLogoBuffer;
    @Value(value="${measurement.cumulative.logo.height:100}")
    private Integer measurementCumulativeLogoHeight;
    @Value(value="${measurement.cumulative.logo.padding:0}")
    private Float measurementCumulativeLogoPadding;
    @Value(value="${measurement.cumulative.logo.path:}")
    private String measurementCumulativeLogoPath;
    private File measurementCumulativeLogoFile;
    private byte[] measurementCumulativeLogoBuffer;
    @Value(value="${payroll.logo.height:100}")
    private Integer payrollLogoHeight;
    @Value(value="${payroll.logo.padding:0}")
    private Float payrollLogoPadding;
    @Value(value="${payroll.logo.path:}")
    private String payrollLogoPath;
    private File payrollLogoFile;
    private byte[] payrollLogoBuffer;
    @Value(value="${stage.logo.height:100}")
    private Integer stageLogoHeight;
    @Value(value="${stage.logo.padding:0}")
    private Float stageLogoPadding;
    @Value(value="${stage.logo.path:}")
    private String stageLogoPath;
    private File stageLogoFile;
    private byte[] stageLogoFileBuffer;

    @PostConstruct
    public void postConstruct() throws IOException {
    }

    public void afterPropertiesSet() {
        this.fontRegularBuffer = this.bytesFromResource(this.fontRegularPath);
        this.fontItalicBuffer = this.bytesFromResource(this.fontItalicPath);
        this.fontBoldBuffer = this.bytesFromResource(this.fontBoldPath);
        this.invoiceLogoBuffer = this.bytesFromResource(this.invoiceLogoPath);
        this.measurementLogoBuffer = this.bytesFromResource(this.measurementLogoPath);
        this.measurementCumulativeLogoBuffer = this.bytesFromResource(this.measurementCumulativeLogoPath);
        this.payrollLogoBuffer = this.bytesFromResource(this.payrollLogoPath);
        this.stageLogoFileBuffer = this.bytesFromResource(this.stageLogoPath);
        log.info("Loaded PrintConfig: {}", (Object)this);
    }

    @Nonnull
    private File fileFromResource(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            URL resource = this.getClass().getResource(value);
            if (null != resource) {
                URI uri = resource.toURI();
                return new File(uri);
            }
        }
        catch (Exception e) {
            log.warn("Cannot Read from Resource: {}, e: {} - Falling back to native File Access to: {}", (Object)value, (Object)e.getMessage(), (Object)value);
        }
        return new File(value);
    }

    @Nonnull
    private byte[] bytesFromResource(@NonNull String value) throws IOException {
        byte[] byArray;
        block10: {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            InputStream is = PrintLayoutConfig.class.getResourceAsStream(value);
            try {
                byte[] bytes;
                byArray = bytes = is.readAllBytes();
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Cannot Read from Resource: {}, e: {} - Falling back to native File Access to: {}", (Object)value, (Object)e.getMessage(), (Object)value);
                    File file = new File(value);
                    if (!file.exists()) {
                        throw new RuntimeException("File path does not exist: " + value);
                    }
                    return Files.readAllBytes(file.toPath());
                }
            }
            is.close();
        }
        return byArray;
    }

    public String getFontRegularPath() {
        return this.fontRegularPath;
    }

    public String getFontBoldPath() {
        return this.fontBoldPath;
    }

    public String getFontItalicPath() {
        return this.fontItalicPath;
    }

    public File getFontRegular() {
        return this.fontRegular;
    }

    public byte[] getFontRegularBuffer() {
        return this.fontRegularBuffer;
    }

    public File getFontBold() {
        return this.fontBold;
    }

    public byte[] getFontBoldBuffer() {
        return this.fontBoldBuffer;
    }

    public File getFontItalic() {
        return this.fontItalic;
    }

    public byte[] getFontItalicBuffer() {
        return this.fontItalicBuffer;
    }

    public Integer getAggregationFontSize() {
        return this.aggregationFontSize;
    }

    public Integer getDetailsFontSize() {
        return this.detailsFontSize;
    }

    public Integer getTitleFontSize() {
        return this.titleFontSize;
    }

    public Integer getHeaderFontSize() {
        return this.headerFontSize;
    }

    public Integer getFooterFontSize() {
        return this.footerFontSize;
    }

    public Integer getMetaFontSize() {
        return this.metaFontSize;
    }

    public Integer getAggregationFontSizeSmaller() {
        return this.aggregationFontSizeSmaller;
    }

    public Integer getDetailsFontSizeSmaller() {
        return this.detailsFontSizeSmaller;
    }

    public Integer getTitleFontSizeSmaller() {
        return this.titleFontSizeSmaller;
    }

    public Integer getHeaderFontSizeSmaller() {
        return this.headerFontSizeSmaller;
    }

    public Integer getFooterFontSizeSmaller() {
        return this.footerFontSizeSmaller;
    }

    public Integer getMetaFontSizeSmaller() {
        return this.metaFontSizeSmaller;
    }

    public Integer getAggregationFontSizeSmallest() {
        return this.aggregationFontSizeSmallest;
    }

    public Integer getDetailsFontSizeSmallest() {
        return this.detailsFontSizeSmallest;
    }

    public Integer getTitleFontSizeSmallest() {
        return this.titleFontSizeSmallest;
    }

    public Integer getHeaderFontSizeSmallest() {
        return this.headerFontSizeSmallest;
    }

    public Integer getFooterFontSizeSmallest() {
        return this.footerFontSizeSmallest;
    }

    public Integer getMetaFontSizeSmallest() {
        return this.metaFontSizeSmallest;
    }

    public Float getFooter1Width() {
        return this.footer1Width;
    }

    public Float getFooter2Width() {
        return this.footer2Width;
    }

    public Float getFooter3Width() {
        return this.footer3Width;
    }

    public Float getFooter4Width() {
        return this.footer4Width;
    }

    public Float getFooter5Width() {
        return this.footer5Width;
    }

    public Float getHeader1Width() {
        return this.header1Width;
    }

    public Float getHeader2Width() {
        return this.header2Width;
    }

    public Float getHeader3Width() {
        return this.header3Width;
    }

    public Float getHeader4Width() {
        return this.header4Width;
    }

    public Integer getInvoiceLogoHeight() {
        return this.invoiceLogoHeight;
    }

    public Float getInvoiceLogoPadding() {
        return this.invoiceLogoPadding;
    }

    public String getInvoiceLogoPath() {
        return this.invoiceLogoPath;
    }

    public File getInvoiceLogoFile() {
        return this.invoiceLogoFile;
    }

    public byte[] getInvoiceLogoBuffer() {
        return this.invoiceLogoBuffer;
    }

    public Integer getMeasurementLogoHeight() {
        return this.measurementLogoHeight;
    }

    public Float getMeasurementLogoPadding() {
        return this.measurementLogoPadding;
    }

    public String getMeasurementLogoPath() {
        return this.measurementLogoPath;
    }

    public File getMeasurementLogoFile() {
        return this.measurementLogoFile;
    }

    public byte[] getMeasurementLogoBuffer() {
        return this.measurementLogoBuffer;
    }

    public Integer getMeasurementCumulativeLogoHeight() {
        return this.measurementCumulativeLogoHeight;
    }

    public Float getMeasurementCumulativeLogoPadding() {
        return this.measurementCumulativeLogoPadding;
    }

    public String getMeasurementCumulativeLogoPath() {
        return this.measurementCumulativeLogoPath;
    }

    public File getMeasurementCumulativeLogoFile() {
        return this.measurementCumulativeLogoFile;
    }

    public byte[] getMeasurementCumulativeLogoBuffer() {
        return this.measurementCumulativeLogoBuffer;
    }

    public Integer getPayrollLogoHeight() {
        return this.payrollLogoHeight;
    }

    public Float getPayrollLogoPadding() {
        return this.payrollLogoPadding;
    }

    public String getPayrollLogoPath() {
        return this.payrollLogoPath;
    }

    public File getPayrollLogoFile() {
        return this.payrollLogoFile;
    }

    public byte[] getPayrollLogoBuffer() {
        return this.payrollLogoBuffer;
    }

    public Integer getStageLogoHeight() {
        return this.stageLogoHeight;
    }

    public Float getStageLogoPadding() {
        return this.stageLogoPadding;
    }

    public String getStageLogoPath() {
        return this.stageLogoPath;
    }

    public File getStageLogoFile() {
        return this.stageLogoFile;
    }

    public byte[] getStageLogoFileBuffer() {
        return this.stageLogoFileBuffer;
    }

    public void setFontRegularPath(String fontRegularPath) {
        this.fontRegularPath = fontRegularPath;
    }

    public void setFontBoldPath(String fontBoldPath) {
        this.fontBoldPath = fontBoldPath;
    }

    public void setFontItalicPath(String fontItalicPath) {
        this.fontItalicPath = fontItalicPath;
    }

    public void setFontRegular(File fontRegular) {
        this.fontRegular = fontRegular;
    }

    public void setFontRegularBuffer(byte[] fontRegularBuffer) {
        this.fontRegularBuffer = fontRegularBuffer;
    }

    public void setFontBold(File fontBold) {
        this.fontBold = fontBold;
    }

    public void setFontBoldBuffer(byte[] fontBoldBuffer) {
        this.fontBoldBuffer = fontBoldBuffer;
    }

    public void setFontItalic(File fontItalic) {
        this.fontItalic = fontItalic;
    }

    public void setFontItalicBuffer(byte[] fontItalicBuffer) {
        this.fontItalicBuffer = fontItalicBuffer;
    }

    public void setAggregationFontSize(Integer aggregationFontSize) {
        this.aggregationFontSize = aggregationFontSize;
    }

    public void setDetailsFontSize(Integer detailsFontSize) {
        this.detailsFontSize = detailsFontSize;
    }

    public void setTitleFontSize(Integer titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public void setHeaderFontSize(Integer headerFontSize) {
        this.headerFontSize = headerFontSize;
    }

    public void setFooterFontSize(Integer footerFontSize) {
        this.footerFontSize = footerFontSize;
    }

    public void setMetaFontSize(Integer metaFontSize) {
        this.metaFontSize = metaFontSize;
    }

    public void setAggregationFontSizeSmaller(Integer aggregationFontSizeSmaller) {
        this.aggregationFontSizeSmaller = aggregationFontSizeSmaller;
    }

    public void setDetailsFontSizeSmaller(Integer detailsFontSizeSmaller) {
        this.detailsFontSizeSmaller = detailsFontSizeSmaller;
    }

    public void setTitleFontSizeSmaller(Integer titleFontSizeSmaller) {
        this.titleFontSizeSmaller = titleFontSizeSmaller;
    }

    public void setHeaderFontSizeSmaller(Integer headerFontSizeSmaller) {
        this.headerFontSizeSmaller = headerFontSizeSmaller;
    }

    public void setFooterFontSizeSmaller(Integer footerFontSizeSmaller) {
        this.footerFontSizeSmaller = footerFontSizeSmaller;
    }

    public void setMetaFontSizeSmaller(Integer metaFontSizeSmaller) {
        this.metaFontSizeSmaller = metaFontSizeSmaller;
    }

    public void setAggregationFontSizeSmallest(Integer aggregationFontSizeSmallest) {
        this.aggregationFontSizeSmallest = aggregationFontSizeSmallest;
    }

    public void setDetailsFontSizeSmallest(Integer detailsFontSizeSmallest) {
        this.detailsFontSizeSmallest = detailsFontSizeSmallest;
    }

    public void setTitleFontSizeSmallest(Integer titleFontSizeSmallest) {
        this.titleFontSizeSmallest = titleFontSizeSmallest;
    }

    public void setHeaderFontSizeSmallest(Integer headerFontSizeSmallest) {
        this.headerFontSizeSmallest = headerFontSizeSmallest;
    }

    public void setFooterFontSizeSmallest(Integer footerFontSizeSmallest) {
        this.footerFontSizeSmallest = footerFontSizeSmallest;
    }

    public void setMetaFontSizeSmallest(Integer metaFontSizeSmallest) {
        this.metaFontSizeSmallest = metaFontSizeSmallest;
    }

    public void setFooter1Width(Float footer1Width) {
        this.footer1Width = footer1Width;
    }

    public void setFooter2Width(Float footer2Width) {
        this.footer2Width = footer2Width;
    }

    public void setFooter3Width(Float footer3Width) {
        this.footer3Width = footer3Width;
    }

    public void setFooter4Width(Float footer4Width) {
        this.footer4Width = footer4Width;
    }

    public void setFooter5Width(Float footer5Width) {
        this.footer5Width = footer5Width;
    }

    public void setHeader1Width(Float header1Width) {
        this.header1Width = header1Width;
    }

    public void setHeader2Width(Float header2Width) {
        this.header2Width = header2Width;
    }

    public void setHeader3Width(Float header3Width) {
        this.header3Width = header3Width;
    }

    public void setHeader4Width(Float header4Width) {
        this.header4Width = header4Width;
    }

    public void setInvoiceLogoHeight(Integer invoiceLogoHeight) {
        this.invoiceLogoHeight = invoiceLogoHeight;
    }

    public void setInvoiceLogoPadding(Float invoiceLogoPadding) {
        this.invoiceLogoPadding = invoiceLogoPadding;
    }

    public void setInvoiceLogoPath(String invoiceLogoPath) {
        this.invoiceLogoPath = invoiceLogoPath;
    }

    public void setInvoiceLogoFile(File invoiceLogoFile) {
        this.invoiceLogoFile = invoiceLogoFile;
    }

    public void setInvoiceLogoBuffer(byte[] invoiceLogoBuffer) {
        this.invoiceLogoBuffer = invoiceLogoBuffer;
    }

    public void setMeasurementLogoHeight(Integer measurementLogoHeight) {
        this.measurementLogoHeight = measurementLogoHeight;
    }

    public void setMeasurementLogoPadding(Float measurementLogoPadding) {
        this.measurementLogoPadding = measurementLogoPadding;
    }

    public void setMeasurementLogoPath(String measurementLogoPath) {
        this.measurementLogoPath = measurementLogoPath;
    }

    public void setMeasurementLogoFile(File measurementLogoFile) {
        this.measurementLogoFile = measurementLogoFile;
    }

    public void setMeasurementLogoBuffer(byte[] measurementLogoBuffer) {
        this.measurementLogoBuffer = measurementLogoBuffer;
    }

    public void setMeasurementCumulativeLogoHeight(Integer measurementCumulativeLogoHeight) {
        this.measurementCumulativeLogoHeight = measurementCumulativeLogoHeight;
    }

    public void setMeasurementCumulativeLogoPadding(Float measurementCumulativeLogoPadding) {
        this.measurementCumulativeLogoPadding = measurementCumulativeLogoPadding;
    }

    public void setMeasurementCumulativeLogoPath(String measurementCumulativeLogoPath) {
        this.measurementCumulativeLogoPath = measurementCumulativeLogoPath;
    }

    public void setMeasurementCumulativeLogoFile(File measurementCumulativeLogoFile) {
        this.measurementCumulativeLogoFile = measurementCumulativeLogoFile;
    }

    public void setMeasurementCumulativeLogoBuffer(byte[] measurementCumulativeLogoBuffer) {
        this.measurementCumulativeLogoBuffer = measurementCumulativeLogoBuffer;
    }

    public void setPayrollLogoHeight(Integer payrollLogoHeight) {
        this.payrollLogoHeight = payrollLogoHeight;
    }

    public void setPayrollLogoPadding(Float payrollLogoPadding) {
        this.payrollLogoPadding = payrollLogoPadding;
    }

    public void setPayrollLogoPath(String payrollLogoPath) {
        this.payrollLogoPath = payrollLogoPath;
    }

    public void setPayrollLogoFile(File payrollLogoFile) {
        this.payrollLogoFile = payrollLogoFile;
    }

    public void setPayrollLogoBuffer(byte[] payrollLogoBuffer) {
        this.payrollLogoBuffer = payrollLogoBuffer;
    }

    public void setStageLogoHeight(Integer stageLogoHeight) {
        this.stageLogoHeight = stageLogoHeight;
    }

    public void setStageLogoPadding(Float stageLogoPadding) {
        this.stageLogoPadding = stageLogoPadding;
    }

    public void setStageLogoPath(String stageLogoPath) {
        this.stageLogoPath = stageLogoPath;
    }

    public void setStageLogoFile(File stageLogoFile) {
        this.stageLogoFile = stageLogoFile;
    }

    public void setStageLogoFileBuffer(byte[] stageLogoFileBuffer) {
        this.stageLogoFileBuffer = stageLogoFileBuffer;
    }

    public String toString() {
        return "PrintLayoutConfig(fontRegularPath=" + this.getFontRegularPath() + ", fontBoldPath=" + this.getFontBoldPath() + ", fontItalicPath=" + this.getFontItalicPath() + ", fontRegular=" + String.valueOf(this.getFontRegular()) + ", fontBold=" + String.valueOf(this.getFontBold()) + ", fontItalic=" + String.valueOf(this.getFontItalic()) + ", aggregationFontSize=" + this.getAggregationFontSize() + ", detailsFontSize=" + this.getDetailsFontSize() + ", titleFontSize=" + this.getTitleFontSize() + ", headerFontSize=" + this.getHeaderFontSize() + ", footerFontSize=" + this.getFooterFontSize() + ", metaFontSize=" + this.getMetaFontSize() + ", aggregationFontSizeSmaller=" + this.getAggregationFontSizeSmaller() + ", detailsFontSizeSmaller=" + this.getDetailsFontSizeSmaller() + ", titleFontSizeSmaller=" + this.getTitleFontSizeSmaller() + ", headerFontSizeSmaller=" + this.getHeaderFontSizeSmaller() + ", footerFontSizeSmaller=" + this.getFooterFontSizeSmaller() + ", metaFontSizeSmaller=" + this.getMetaFontSizeSmaller() + ", aggregationFontSizeSmallest=" + this.getAggregationFontSizeSmallest() + ", detailsFontSizeSmallest=" + this.getDetailsFontSizeSmallest() + ", titleFontSizeSmallest=" + this.getTitleFontSizeSmallest() + ", headerFontSizeSmallest=" + this.getHeaderFontSizeSmallest() + ", footerFontSizeSmallest=" + this.getFooterFontSizeSmallest() + ", metaFontSizeSmallest=" + this.getMetaFontSizeSmallest() + ", footer1Width=" + this.getFooter1Width() + ", footer2Width=" + this.getFooter2Width() + ", footer3Width=" + this.getFooter3Width() + ", footer4Width=" + this.getFooter4Width() + ", footer5Width=" + this.getFooter5Width() + ", header1Width=" + this.getHeader1Width() + ", header2Width=" + this.getHeader2Width() + ", header3Width=" + this.getHeader3Width() + ", header4Width=" + this.getHeader4Width() + ", invoiceLogoHeight=" + this.getInvoiceLogoHeight() + ", invoiceLogoPadding=" + this.getInvoiceLogoPadding() + ", invoiceLogoPath=" + this.getInvoiceLogoPath() + ", invoiceLogoFile=" + String.valueOf(this.getInvoiceLogoFile()) + ", measurementLogoHeight=" + this.getMeasurementLogoHeight() + ", measurementLogoPadding=" + this.getMeasurementLogoPadding() + ", measurementLogoPath=" + this.getMeasurementLogoPath() + ", measurementLogoFile=" + String.valueOf(this.getMeasurementLogoFile()) + ", measurementCumulativeLogoHeight=" + this.getMeasurementCumulativeLogoHeight() + ", measurementCumulativeLogoPadding=" + this.getMeasurementCumulativeLogoPadding() + ", measurementCumulativeLogoPath=" + this.getMeasurementCumulativeLogoPath() + ", measurementCumulativeLogoFile=" + String.valueOf(this.getMeasurementCumulativeLogoFile()) + ", payrollLogoHeight=" + this.getPayrollLogoHeight() + ", payrollLogoPadding=" + this.getPayrollLogoPadding() + ", payrollLogoPath=" + this.getPayrollLogoPath() + ", payrollLogoFile=" + String.valueOf(this.getPayrollLogoFile()) + ", stageLogoHeight=" + this.getStageLogoHeight() + ", stageLogoPadding=" + this.getStageLogoPadding() + ", stageLogoPath=" + this.getStageLogoPath() + ", stageLogoFile=" + String.valueOf(this.getStageLogoFile()) + ")";
    }
}

