/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.persistence.EntityManagerFactory;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"de.qfm.erp.service.repository"})
public class JpaConfig {
    private static final Logger log = LogManager.getLogger(JpaConfig.class);
    public static final String JPA_ENTITY_BASE_PACKAGE = "de.qfm.erp.service.model.jpa";
    @Value(value="${app.datasource.jdbc-url}")
    private String jdbcUrl;
    @Value(value="${app.datasource.username}")
    private String username;
    @Value(value="${app.datasource.password}")
    private String password;
    @Value(value="${app.datasource.schema}")
    private String schema;
    @Value(value="${app.datasource.driver}")
    private String driver;
    @Value(value="${app.datasource.internal.configuration.maximum-pool-size}")
    private int poolSize;
    @Value(value="${spring.jpa.database-platform}")
    private String platform;
    @Value(value="${spring.jpa.properties.hibernate.dialect}")
    private String dialect;
    @Value(value="${application.database.clause.limit:500}")
    private int databaseClauseLimit;

    @Bean(name={"dataSource"})
    @LiquibaseDataSource
    @Primary
    public DataSource dataSource() {
        log.info("JDBC Url: {}", (Object)this.jdbcUrl);
        log.info("UserName: {}", (Object)this.username);
        log.info("Password: {}", (Object)StringUtils.abbreviateMiddle((String)this.password, (String)"*", (int)4));
        log.info("Schema: {}", (Object)this.schema);
        log.info("Driver: {}", (Object)this.driver);
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.jdbcUrl);
        hikariConfig.setUsername(this.username);
        hikariConfig.setPassword(this.password);
        hikariConfig.setDriverClassName(this.driver);
        hikariConfig.setConnectionInitSql(String.format("alter session set current_schema = %s", this.schema));
        hikariConfig.setMaximumPoolSize(this.poolSize);
        return new HikariDataSource(hikariConfig);
    }

    @Bean(name={"entityManagerFactory"})
    @Primary
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(@Qualifier(value="dataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)this.vendorAdaptor());
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setPersistenceProviderClass(HibernatePersistenceProvider.class);
        entityManagerFactoryBean.setPackagesToScan(new String[]{JPA_ENTITY_BASE_PACKAGE});
        entityManagerFactoryBean.setJpaProperties(this.jpaHibernateProperties());
        entityManagerFactoryBean.afterPropertiesSet();
        return entityManagerFactoryBean;
    }

    @Bean(name={"transactionManager"})
    @Primary
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

    @Nonnull
    private HibernateJpaVendorAdapter vendorAdaptor() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        vendorAdapter.setDatabasePlatform(this.platform);
        return vendorAdapter;
    }

    @Nonnull
    private Properties jpaHibernateProperties() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", this.dialect);
        return properties;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDriver() {
        return this.driver;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getDialect() {
        return this.dialect;
    }

    public int getDatabaseClauseLimit() {
        return this.databaseClauseLimit;
    }
}

