/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.qfm.erp.service.configuration.CacheNames;
import de.qfm.erp.service.model.internal.businessunit.BusinessUnitTree;
import de.qfm.erp.service.model.internal.role.CachedRole;
import de.qfm.erp.service.model.internal.user.CachedAutoCompleteUser;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import jakarta.annotation.PostConstruct;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfig
implements InitializingBean,
CacheNames {
    private static final Logger log = LogManager.getLogger(CacheConfig.class);
    public static final int CONCURRENCY_LEVEL = 16;
    @Value(value="${cache.business.unit.tree.evict.after.write.seconds}")
    private int businessUnitTreeCacheEvictAfterWriteSeconds;
    @Value(value="${cache.user.assigned.to.evict.after.write.seconds}")
    private int userHierarchyCacheEvictAfterWriteSeconds;
    @Value(value="${cache.user.privilege.evict.after.write.seconds}")
    private int userPrivilegeCacheEvictAfterWriteSeconds;
    @Value(value="${cache.role.evict.after.write.seconds}")
    private int roleCacheEvictAfterWriteSeconds;

    public void afterPropertiesSet() {
    }

    @Bean(value={"business_unit_tree_cache"})
    public Cache<String, BusinessUnitTree> businessUnitTreeCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.businessUnitTreeCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @Bean(value={"role_cache"})
    public Cache<String, CachedRole> roleCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.roleCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @Bean(value={"user_hierarchy_cache"})
    public Cache<String, Iterable<CachedUser>> userHierarchyCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.userHierarchyCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @Bean(value={"user_valid_at_month_cache"})
    public Cache<LocalDate, Iterable<CachedUser>> userValidAtCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.userHierarchyCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @Bean(value={"user_valid_in_range_cache"})
    public Cache<String, Iterable<CachedAutoCompleteUser>> usersValidInDateRangeCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.userHierarchyCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @Bean(value={"user_privilege_cache"})
    public Cache<String, Iterable<EPrivilege>> userPrivilegeCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite((long)this.userPrivilegeCacheEvictAfterWriteSeconds, TimeUnit.SECONDS).build();
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded CacheConfig: {}", (Object)this);
    }

    public int getBusinessUnitTreeCacheEvictAfterWriteSeconds() {
        return this.businessUnitTreeCacheEvictAfterWriteSeconds;
    }

    public int getUserHierarchyCacheEvictAfterWriteSeconds() {
        return this.userHierarchyCacheEvictAfterWriteSeconds;
    }

    public int getUserPrivilegeCacheEvictAfterWriteSeconds() {
        return this.userPrivilegeCacheEvictAfterWriteSeconds;
    }

    public int getRoleCacheEvictAfterWriteSeconds() {
        return this.roleCacheEvictAfterWriteSeconds;
    }

    public void setBusinessUnitTreeCacheEvictAfterWriteSeconds(int businessUnitTreeCacheEvictAfterWriteSeconds) {
        this.businessUnitTreeCacheEvictAfterWriteSeconds = businessUnitTreeCacheEvictAfterWriteSeconds;
    }

    public void setUserHierarchyCacheEvictAfterWriteSeconds(int userHierarchyCacheEvictAfterWriteSeconds) {
        this.userHierarchyCacheEvictAfterWriteSeconds = userHierarchyCacheEvictAfterWriteSeconds;
    }

    public void setUserPrivilegeCacheEvictAfterWriteSeconds(int userPrivilegeCacheEvictAfterWriteSeconds) {
        this.userPrivilegeCacheEvictAfterWriteSeconds = userPrivilegeCacheEvictAfterWriteSeconds;
    }

    public void setRoleCacheEvictAfterWriteSeconds(int roleCacheEvictAfterWriteSeconds) {
        this.roleCacheEvictAfterWriteSeconds = roleCacheEvictAfterWriteSeconds;
    }

    public String toString() {
        return "CacheConfig(businessUnitTreeCacheEvictAfterWriteSeconds=" + this.getBusinessUnitTreeCacheEvictAfterWriteSeconds() + ", userHierarchyCacheEvictAfterWriteSeconds=" + this.getUserHierarchyCacheEvictAfterWriteSeconds() + ", userPrivilegeCacheEvictAfterWriteSeconds=" + this.getUserPrivilegeCacheEvictAfterWriteSeconds() + ", roleCacheEvictAfterWriteSeconds=" + this.getRoleCacheEvictAfterWriteSeconds() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheConfig)) {
            return false;
        }
        CacheConfig other = (CacheConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getBusinessUnitTreeCacheEvictAfterWriteSeconds() != other.getBusinessUnitTreeCacheEvictAfterWriteSeconds()) {
            return false;
        }
        if (this.getUserHierarchyCacheEvictAfterWriteSeconds() != other.getUserHierarchyCacheEvictAfterWriteSeconds()) {
            return false;
        }
        if (this.getUserPrivilegeCacheEvictAfterWriteSeconds() != other.getUserPrivilegeCacheEvictAfterWriteSeconds()) {
            return false;
        }
        return this.getRoleCacheEvictAfterWriteSeconds() == other.getRoleCacheEvictAfterWriteSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBusinessUnitTreeCacheEvictAfterWriteSeconds();
        result = result * 59 + this.getUserHierarchyCacheEvictAfterWriteSeconds();
        result = result * 59 + this.getUserPrivilegeCacheEvictAfterWriteSeconds();
        result = result * 59 + this.getRoleCacheEvictAfterWriteSeconds();
        return result;
    }
}

